// This program reads the input from the IR sensor on pin A0 and puts the
// value on the PWM ports to vary the motor speed. It also sends the value to
// the serial port.

#include<16F877.H>
#device adc=10;							//Set ADC to 10 bit
#fuses HS,NOWDT,NOPROTECT,NOBROWNOUT,NOPUT  //Configuration Fuses
#use delay(clock=20000000)				//20Mhz Clock for wait functions
#use rs232(baud=9600,xmit=PIN_c6,rcv=PIN_C7,PARITY=N,BITS=8)//set up RS-232
#org 0x1F00,0x1FFF{}					//Reserve Memory for Bootloader

long ADC_Result;						//Holds number of steps to take.

void main() {
	puts("PIC16F877 - ADC Test\r\n");	//Print a message to serial port.

	setup_adc_ports(ANALOG_RA3_REF);	//all analog with Vref on pin AN3		
	setup_adc(ADC_CLOCK_DIV_32);		//Set ADC conversion clock speed.
	set_adc_channel(0);					//set ADC channel to port 0 (pin 2, AN0).
	
	setup_ccp1(CCP_PWM);				//Set up PWM on CCP1.
	setup_ccp2(CCP_PWM);				//Set up PWM on CCP2.
	setup_timer_2(T2_DIV_BY_4,254,10);	//set up Timer2 for 4901Hz PWM Period and
										//to trigger an interrupt every 2.04 ms.
										//TIMER2 settings for 20 MHz clock.
	set_pwm1_duty(0);					//Start with duty cycle of 0%.
	set_pwm2_duty(0);					//Start with duty cycle of 0%.
	output_high(pin_D1);				//set direction for motor1.
	output_high(pin_D2);				//set direction for motor2.

while (true){
	ADC_Result = read_ADC();
	set_pwm1_duty(ADC_Result);			//Vary motor speed with ADC result.
	set_pwm2_duty(ADC_Result);			//Vary motor speed with ADC result.
//    if (ADC_Result > 512) 
//        set_pwm1_duty(1000);
//      else
//        set_pwm1_duty(0);
	printf("ADC = %4Lu\r",ADC_Result);	//Send adc result to serial port.
	delay_ms(200);
	}
}
